//=============================================================================
// ut_ShieldBelt.
//=============================================================================
class Pickup_ShieldBelt extends UT_ShieldBelt;

var UT_ShieldBeltEffect MyEffect;
var() string TeamFireTextureStrings[4];
var() string TeamTextureStrings[4];
var firetexture TeamFireTextures[4];
var texture TeamTextures[4];
var int TeamNum;

event float BotDesireability( pawn Bot )
{
	return -1;

	return Super.BotDesireability(Bot);
}

auto state Pickup
{	
	function Touch( actor Other )
	{
		local Inventory Copy;
		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
		{
			Copy = SpawnCopy(Pawn(Other));
			if (bActivatable && Pawn(Other).SelectedItem==None) 
				Pawn(Other).SelectedItem=Copy;
			if (bActivatable && bAutoActivate && Pawn(Other).bAutoActivate) Copy.Activate();
			if ( PickupMessageClass == None )
				Pawn(Other).ClientMessage(PickupMessage, 'Pickup');
			else
				Pawn(Other).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
			PlaySound (PickupSound,,2.0);	
			Pickup(Copy).PickupFunction(Pawn(Other));
		}
	}

	function BeginState()
	{
		Super.BeginState();
		NumCopies = 0;
	}
}


function bool HandlePickupQuery( inventory Item )
{
/*
	local Inventory I;

	if (item.class == class) 
	{
		// remove other armors
		for ( I=Owner.Inventory; I!=None; I=I.Inventory )
			if ( I.bIsAnArmor && (I != self) )
				I.Destroy();
	}
*/
	return Super.HandlePickupQuery(Item);
}

function ArmorImpactEffect(vector HitLocation)
{ 
	if ( Owner.IsA('PlayerPawn') )
	{
		PlayerPawn(Owner).ClientFlash(-0.05,vect(400,400,400));
		PlayerPawn(Owner).PlaySound(DeActivateSound, SLOT_None, 2.7*PlayerPawn(Owner).SoundDampening);
	}
	if ( MyEffect != None )
	{
		//MyEffect.Texture = MyEffect.LowDetailTexture;
		MyEffect.ScaleGlow = 4.0;
		MyEffect.Fatness = 255;
		SetTimer(0.8, false);
	}
}

function Timer()
{
	if ( MyEffect != None )
	{
		MyEffect.Fatness = MyEffect.Default.Fatness;
		SetEffectTexture();
	}
}

function Destroyed()
{
	if ( Owner != None )
	{
		Owner.SetDefaultDisplayProperties();
		if( Owner.Inventory != None )
			Owner.Inventory.SetOwnerDisplay();
	}
	if ( MyEffect != None )
		MyEffect.Destroy();
	Super.Destroyed();
}

function PickupFunction(Pawn Other)
{
	local Inventory I;

	MyEffect = Spawn(class'UT_ShieldBeltEffect', Other,,Other.Location, Other.Rotation); 
	MyEffect.Mesh = Owner.Mesh;
	MyEffect.DrawScale = Owner.Drawscale;

	if ( Level.Game.bTeamGame && (Other.PlayerReplicationInfo != None) )
		TeamNum = Other.PlayerReplicationInfo.Team;
	else
		TeamNum = 3;
	SetEffectTexture();

	I = Pawn(Owner).FindInventoryType(class'UT_Invisibility');
	if ( I != None )
		MyEffect.bHidden = true;
/*	
	// remove other armors
	for ( I=Owner.Inventory; I!=None; I=I.Inventory )
		if ( I.bIsAnArmor && (I != self) )
			I.Destroy();
*/
}

function SetEffectTexture()
{
	if ( TeamNum != 3 )
		MyEffect.ScaleGlow = 0.5;
	else
		MyEffect.ScaleGlow = 1.0;
	MyEffect.ScaleGlow *= (0.25 + 0.75 * Charge/Default.Charge);
	if ( TeamFireTextures[TeamNum] == None )
		TeamFireTextures[TeamNum] =FireTexture(DynamicLoadObject(TeamFireTextureStrings[TeamNum], class'Texture'));
	MyEffect.Texture = TeamFireTextures[TeamNum];
	if ( TeamTextures[TeamNum] == None )
		TeamTextures[TeamNum] = Texture(DynamicLoadObject(TeamTextureStrings[TeamNum], class'Texture'));
	MyEffect.LowDetailTexture = TeamTextures[TeamNum];
}

defaultproperties
{
     TeamFireTextureStrings(0)="UnrealShare.Belt_fx.ShieldBelt.RedShield"
     TeamFireTextureStrings(1)="UnrealShare.Belt_fx.ShieldBelt.BlueShield"
     TeamFireTextureStrings(2)="UnrealShare.Belt_fx.ShieldBelt.Greenshield"
     TeamFireTextureStrings(3)="UnrealShare.Belt_fx.ShieldBelt.N_Shield"
     TeamTextureStrings(0)="UnrealShare.Belt_fx.ShieldBelt.newred"
     TeamTextureStrings(1)="UnrealShare.Belt_fx.ShieldBelt.newblue"
     TeamTextureStrings(2)="UnrealShare.Belt_fx.ShieldBelt.newgreen"
     TeamTextureStrings(3)="UnrealShare.Belt_fx.ShieldBelt.newgold"
     TeamFireTextures(0)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield'
     TeamFireTextures(1)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.BlueShield'
     TeamFireTextures(2)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.Greenshield'
     TeamFireTextures(3)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.N_Shield'
     TeamTextures(0)=Texture'UnrealShare.Belt_fx.ShieldBelt.newred'
     TeamTextures(1)=Texture'UnrealShare.Belt_fx.ShieldBelt.newblue'
     TeamTextures(2)=Texture'UnrealShare.Belt_fx.ShieldBelt.newgreen'
     TeamTextures(3)=Texture'UnrealShare.Belt_fx.ShieldBelt.newgold'
     bDisplayableInv=True
     PickupMessage="You got the Shield Belt."
     ItemName="ShieldBelt"
     RespawnTime=60.000000
     PickupViewMesh=LodMesh'Botpack.ShieldBeltMeshM'
     ProtectionType1=ProtectNone
     ProtectionType2=ProtectNone
     Charge=300
     ArmorAbsorption=300
     bIsAnArmor=True
     AbsorptionPriority=10
     MaxDesireability=3.000000
     PickupSound=Sound'UnrealShare.Pickups.BeltSnd'
     DeActivateSound=Sound'UnrealShare.Pickups.Sbelthe2'
     Icon=Texture'UnrealShare.Icons.I_ShieldBelt'
     bOwnerNoSee=True
     RemoteRole=ROLE_DumbProxy
     Mesh=LodMesh'Botpack.ShieldBeltMeshM'
     CollisionRadius=25.000000
     CollisionHeight=10.000000
}
